let
  fromEnv = var: def:
    let val = builtins.getEnv var; in
    if val != "" then val else def;
in rec {
  shell = "/nix/store/iyfg8vj84k525dr0hrn7463v4m2dq6rk-bash-4.4-p23/bin/bash";
  coreutils = "/nix/store/2aadxdxynjhwpxsfpyh4knh47mm35wh8-coreutils-8.31/bin";
  bzip2 = "/nix/store/xs9pqnq2gmy7yirm7s7p7nzhgp4n4v54-bzip2-1.0.6.0.1-bin/bin/bzip2";
  gzip = "/nix/store/jfdsnq6yd75mwk6qljmq23p1d31xqpmk-gzip-1.10/bin/gzip";
  xz = "/nix/store/71psf41z26b62bpsyaa0sa7vyc7j96sj-xz-5.2.4-bin/bin/xz";
  tar = "/nix/store/jmy89ri2md5skhrrg45nnfgfkhvcaxbf-gnutar-1.32/bin/tar";
  tarFlags = "--warning=no-timestamp";
  tr = "/nix/store/2aadxdxynjhwpxsfpyh4knh47mm35wh8-coreutils-8.31/bin/tr";
  nixBinDir = fromEnv "NIX_BIN_DIR" "/nix/store/9fqvbdisahqp0238vrs7wn5anpri0a65-nix-2.3.6/bin";
  nixPrefix = "/nix/store/9fqvbdisahqp0238vrs7wn5anpri0a65-nix-2.3.6";
  nixLibexecDir = fromEnv "NIX_LIBEXEC_DIR" "/nix/store/9fqvbdisahqp0238vrs7wn5anpri0a65-nix-2.3.6/libexec";
  nixLocalstateDir = "/nix/var";
  nixSysconfDir = "/etc";
  nixStoreDir = fromEnv "NIX_STORE_DIR" "/nix/store";

  # If Nix is installed in the Nix store, then automatically add it as
  # a dependency to the core packages. This ensures that they work
  # properly in a chroot.
  chrootDeps =
    if dirOf nixPrefix == builtins.storeDir then
      [ (builtins.storePath nixPrefix) ]
    else
      [ ];
}
