let
  fromEnv = var: def:
    let val = builtins.getEnv var; in
    if val != "" then val else def;
in rec {
  shell = "/nix/store/ch6r6393g2aryabygwb4cqjxsmsbn5s8-bash-4.4-p23/bin/bash";
  coreutils = "/nix/store/62l1fmmmynxr5q8jc65wllk9wl2fmnp3-coreutils-8.31/bin";
  bzip2 = "/nix/store/f3cgsx8590216k676riyb8l0akfzp88s-bzip2-1.0.6.0.1-bin/bin/bzip2";
  gzip = "/nix/store/xka081y0s1rjz0ph7swn64f84ag288xa-gzip-1.10/bin/gzip";
  xz = "/nix/store/1xd0ffhfgrmkwi607dybj6i1k2nnqgmc-xz-5.2.4-bin/bin/xz";
  tar = "/nix/store/4zfyma1dnmphc5kp4cc6r5fcp26hd0pf-gnutar-1.32/bin/tar";
  tarFlags = "--warning=no-timestamp";
  tr = "/nix/store/62l1fmmmynxr5q8jc65wllk9wl2fmnp3-coreutils-8.31/bin/tr";
  nixBinDir = fromEnv "NIX_BIN_DIR" "/nix/store/72pwn0nm9bjqx9vpi8sgh4bl6g5wh814-nix-2.3.6/bin";
  nixPrefix = "/nix/store/72pwn0nm9bjqx9vpi8sgh4bl6g5wh814-nix-2.3.6";
  nixLibexecDir = fromEnv "NIX_LIBEXEC_DIR" "/nix/store/72pwn0nm9bjqx9vpi8sgh4bl6g5wh814-nix-2.3.6/libexec";
  nixLocalstateDir = "/nix/var";
  nixSysconfDir = "/etc";
  nixStoreDir = fromEnv "NIX_STORE_DIR" "/nix/store";

  # If Nix is installed in the Nix store, then automatically add it as
  # a dependency to the core packages. This ensures that they work
  # properly in a chroot.
  chrootDeps =
    if dirOf nixPrefix == builtins.storeDir then
      [ (builtins.storePath nixPrefix) ]
    else
      [ ];
}
