let
  fromEnv = var: def:
    let val = builtins.getEnv var; in
    if val != "" then val else def;
in rec {
  shell = "/nix/store/kawx6qqji9c8jal32d554whblbjj81l3-bash-4.4-p23/bin/bash";
  coreutils = "/nix/store/pcc3dbxii97a919fm0bs39mqfwlzkdma-coreutils-8.32/bin";
  bzip2 = "/nix/store/x5s77c649m4dd2bqz79kppd7v8wi586p-bzip2-1.0.6.0.2-bin/bin/bzip2";
  gzip = "/nix/store/fmqa3dg1d1gljsxq4gj0qz6f335vkqqj-gzip-1.10/bin/gzip";
  xz = "/nix/store/wgqmlz1k2f7j64jn2b65n9912nhh7bgw-xz-5.2.5-bin/bin/xz";
  tar = "/nix/store/s9yvbydn4zllzkncrjps34npnimjv55q-gnutar-1.34/bin/tar";
  tarFlags = "--warning=no-timestamp";
  tr = "/nix/store/pcc3dbxii97a919fm0bs39mqfwlzkdma-coreutils-8.32/bin/tr";
  nixBinDir = fromEnv "NIX_BIN_DIR" "/nix/store/gshwcgg96lc2jmdgphd7p3q4cp0gvkak-nix-2.3.13/bin";
  nixPrefix = "/nix/store/gshwcgg96lc2jmdgphd7p3q4cp0gvkak-nix-2.3.13";
  nixLibexecDir = fromEnv "NIX_LIBEXEC_DIR" "/nix/store/gshwcgg96lc2jmdgphd7p3q4cp0gvkak-nix-2.3.13/libexec";
  nixLocalstateDir = "/nix/var";
  nixSysconfDir = "/etc";
  nixStoreDir = fromEnv "NIX_STORE_DIR" "/nix/store";

  # If Nix is installed in the Nix store, then automatically add it as
  # a dependency to the core packages. This ensures that they work
  # properly in a chroot.
  chrootDeps =
    if dirOf nixPrefix == builtins.storeDir then
      [ (builtins.storePath nixPrefix) ]
    else
      [ ];
}
