let
  fromEnv = var: def:
    let val = builtins.getEnv var; in
    if val != "" then val else def;
in rec {
  shell = "/nix/store/d58jryr2ai0i0y20g3csyvk30pagivyr-bash-4.4-p23/bin/bash";
  coreutils = "/nix/store/4656dfcxbr6y306g16v19knddwqqzv9s-coreutils-8.32/bin";
  bzip2 = "/nix/store/ahdrcqcx6wncs57zl3s62c268fkbcggx-bzip2-1.0.6.0.2-bin/bin/bzip2";
  gzip = "/nix/store/x841j973bg1dqw2xq7l0kizcpshdisds-gzip-1.10/bin/gzip";
  xz = "/nix/store/caxahvy4y5lfh15y0il88rjp2sx7zp4b-xz-5.2.5-bin/bin/xz";
  tar = "/nix/store/9dv4avjgxq1f5fyixyhwa3zw7qg6k8gk-gnutar-1.34/bin/tar";
  tarFlags = "--warning=no-timestamp";
  tr = "/nix/store/4656dfcxbr6y306g16v19knddwqqzv9s-coreutils-8.32/bin/tr";
  nixBinDir = fromEnv "NIX_BIN_DIR" "/nix/store/qksmcm7vxmkha0wx0dx36gc9m11mhbjy-nix-2.3.13/bin";
  nixPrefix = "/nix/store/qksmcm7vxmkha0wx0dx36gc9m11mhbjy-nix-2.3.13";
  nixLibexecDir = fromEnv "NIX_LIBEXEC_DIR" "/nix/store/qksmcm7vxmkha0wx0dx36gc9m11mhbjy-nix-2.3.13/libexec";
  nixLocalstateDir = "/nix/var";
  nixSysconfDir = "/etc";
  nixStoreDir = fromEnv "NIX_STORE_DIR" "/nix/store";

  # If Nix is installed in the Nix store, then automatically add it as
  # a dependency to the core packages. This ensures that they work
  # properly in a chroot.
  chrootDeps =
    if dirOf nixPrefix == builtins.storeDir then
      [ (builtins.storePath nixPrefix) ]
    else
      [ ];
}
